<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

error_reporting(E_ALL);
ini_set('display_errors', 'On');

require __DIR__ . '/../vendor/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Static/fallback user ID
$user_id = $_POST['user_id'];

// Get POST inputs
$title = $_POST['title'] ?? 'New message from e{Profitify}';
$message = $_POST['message'] ?? 'Something Went Wrong. Please Contact to Administrator!';
$url = $_POST['url'] ?? 'https://eprofitify.com/';

// Connect to database
$conn = mysqli_connect('localhost', 'eprofitify_admin', 'V+H{Rb%{m7f%', 'eprofitify_db');
$results = [];

if (!$conn) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Fetch user's FCM token from DB
$query = "SELECT `fname`, `lname`, `fcm_token` FROM `users` WHERE `unique_id` = '$user_id'";
$result = mysqli_query($conn, $query);

if ($result && mysqli_num_rows($result)) {
    $userData = mysqli_fetch_assoc($result);
    $fcm_token_json = $userData['fcm_token'];
    $subscriptionList = json_decode($fcm_token_json, true);

    if (json_last_error() === JSON_ERROR_NONE && is_array($subscriptionList)) {
        // Support for both single and array of subscriptions
        $subscriptions = isset($subscriptionList[0]) ? $subscriptionList : [$subscriptionList];

        // VAPID keys
        $auth = [
            'VAPID' => [
                'subject' => 'https://github.com/Minishlink/web-push-php-example/',
                'publicKey' => file_get_contents(__DIR__ . '/../keys/public_key.txt'),
                'privateKey' => file_get_contents(__DIR__ . '/../keys/private_key.txt'),
            ],
        ];

        $webPush = new WebPush($auth);
        $message = str_replace(["\\r", "\\n"], ["\r", "\n"], $message);

        // Payload structure
        $payload = json_encode([
            'title' => $title,
            'message' => $message,
            'icon' => 'https://eprofitify.com/eprofitify-logo.png',
            'url' => $url,
        ]);

        // Loop over each subscription
        foreach ($subscriptions as $sub) {
            if (
                isset($sub['endpoint']) &&
                isset($sub['authToken']) &&
                isset($sub['publicKey'])
            ) {
                $formattedSubscription = [
                    'endpoint' => $sub['endpoint'],
                    'keys' => [
                        'auth' => $sub['authToken'],
                        'p256dh' => $sub['publicKey'],
                    ]
                ];

                try {
                    $subscription = Subscription::create($formattedSubscription);
                    $report = $webPush->sendOneNotification($subscription, $payload);
                    $endpoint = $report->getRequest()->getUri()->__toString();

                    if ($report->isSuccess()) {
                        $results[] = ["endpoint" => $endpoint, "status" => "success"];
                    } else {
                        $results[] = [
                            "endpoint" => $endpoint,
                            "status" => "failed",
                            "reason" => $report->getReason()
                        ];
                    }
                } catch (Exception $e) {
                    $results[] = [
                        "endpoint" => $sub['endpoint'] ?? 'unknown',
                        "status" => "failed",
                        "reason" => $e->getMessage()
                    ];
                }
            } else {
                $results[] = [
                    "status" => "failed",
                    "reason" => "Missing required subscription fields"
                ];
            }
        }
    } else {
        $results[] = ["status" => "failed", "reason" => "Invalid FCM token JSON"];
    }
} else {
    $results[] = ["status" => "failed", "reason" => "User not found"];
}

// Return JSON response
header('Content-Type: application/json');
echo json_encode([
    'status' => 'success',
    'results' => $results
]);
